-- ahkfunc.lua 1.0.0.2
-- double.tap.inside@gmail.com

local lfs = require("lfs")
local ffi = require("ffi")

local Ahkfunc = {}

setmetatable(Ahkfunc, {
  __call = function(self)
    return self.__init()
  end
})

function Ahkfunc.__init()
	local self = {}
	self._address = tostring(self):match("0x.*")
	
	function self._random()
		math.randomseed(os.clock() * 1000 + os.time())
		return math.random(1, os.clock() * 1000 + os.time())
	end
	
	self._path = {}
	self._path.resources = getGameDirectory().."\\ahkfunc"
	self._path.commands = self._path.resources.."\\commands"
	self._path.hotkeys = self._path.resources.."\\hotkeys"
	self._path.key_files = self._path.hotkeys.."\\key_files"
	self._path.key_states = self._path.hotkeys.."\\key_states"
	
	
	ffi.cdef [[
		typedef int BOOL;
		typedef unsigned long HANDLE;
		typedef HANDLE HWND;
 
		HWND GetActiveWindow(void);
	]]
	
	self._HWND = ffi.C.GetActiveWindow()	
	
	self._key_states = {}
	self._key_files = {}
	self._key_capturing_is_paused = false
	
	self._KEYSTATE_DOWN = 1
	self._KEYSTATE_UP = 0
	
	function self.captureHotkey(keyname)
		if not self._key_states[keyname] then
			self._key_states[keyname] = self._KEYSTATE_UP
			self._key_files[keyname] = io.open(self._path.key_files.."\\"..self._address.."."..self._HWND.."."..keyname, "w")
		end
	end
	
	function self.releaseHotkey(keyname)
		if self._key_states[keyname] then
			self._key_states[keyname] = nil
			self._key_files[keyname]:close()
		end
	end
	
	
	function self.onHotkeyDown(keyname)
		if self._key_capturing_is_paused then
			return false
		elseif self._key_states[keyname] == self._KEYSTATE_UP then
			for filename in lfs.dir(self._path.key_states) do
				if filename == self._HWND.."."..keyname then
					self._key_states[keyname] = self._KEYSTATE_DOWN
					return true
				end
			end
			return false
		
		elseif self._key_states[keyname] == self._KEYSTATE_DOWN then
			for filename in lfs.dir(self._path.key_states) do
				if filename == self._HWND.."."..keyname then
					return false
				end
			end
			self._key_states[keyname] = self._KEYSTATE_UP
			return false
		end
	end
	
	function self.onHotkeyUp(keyname)
		if self._key_capturing_is_paused then
			return false
		elseif self._key_states[keyname] == self._KEYSTATE_UP then
			for filename in lfs.dir(self._path.key_states) do
				if filename == self._HWND ..".".. keyname then
					self._key_states[keyname] = self._KEYSTATE_DOWN -------
					return false
				end
			end
			return false
		
		elseif self._key_states[keyname] == self._KEYSTATE_DOWN then
			for filename in lfs.dir(self._path.key_states) do
				if filename == self._HWND.."."..keyname then
					return false
				end
			end
			self._key_states[keyname] = self._KEYSTATE_UP
			return true
		end
	end
	
	function self.onHotkeyPush(keyname)
		if self._key_capturing_is_paused then
			return false
		elseif self._key_states[keyname] then
			for filename in lfs.dir(self._path.key_states) do
				if filename == self._HWND.."."..keyname then	
					os.remove(self._path.key_states.."\\"..filename)
					return true
				end
			end
			return false
		end
	end
	
	function self.isHotkeyDown(keyname)
		if self._key_capturing_is_paused then
			return false
		elseif self._key_states[keyname] then
			for filename in lfs.dir(self._path.key_states) do
				if filename == self._HWND.."."..keyname then
					return true
				end
			end
			return false
		end
	end
	
	
	--          ,       .
	--         ,   
	self._thread = lua_thread.create_suspended(function()
		while true do
			wait(0)
			if isPauseMenuActive() and not self._key_capturing_is_paused then
				for keyname, state in pairs(self._key_states) do
					self._key_files[keyname]:close()
				end
				self._key_capturing_is_paused = true
			
			elseif not isPauseMenuActive() and self._key_capturing_is_paused then
				for keyname, keystate in pairs(self._key_states) do
					self._key_files[keyname] = io.open(self._path.key_files.."\\"..self._address.."."..self._HWND.."."..keyname, "w")
				end
				self._key_capturing_is_paused = false
			end 
		end
	end)
	self._thread.work_in_pause = true
	self._thread:run()
	

	function self.run(command)
		local file = io.open(self._path.commands.."\\"..self._HWND.."."..self._address..self._random(), "w")
		file:write("run\n")
		file:write(command)
		file:close()
	end	
	
	function self.soundPlay(filename)
		local file = io.open(self._path.commands.."\\"..self._HWND.."."..self._address..self._random(), "w")
		file:write("soundPlay\n")
		file:write(filename)
		file:close()
	end
	
	
	return self
end

return Ahkfunc()